/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.simdebug;

import com.ibm.hwmca.base.simdebug.SysInfoErrorIds;
import com.ibm.hwmca.base.simdebug.SysInfoManagerBean;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

public class SimDebugTasklet
extends PanelTasklet
implements SysInfoErrorIds {
    private static final String TRACE_MASKT = "XSIMTSKT";
    private static final String TRACE_MASKF = "XSIMTSKF";
    private static final String TRACE_MASKD = "XSIMTSKD";
    private static final String APP_NAME = "SystemInfoManager";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.simdebug.res.SysInfoManagerRes";
    private static final String PANEL_NAME = "SystemInfoManagerPanel";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(22, "SystemInfoManager");
    private PresentationTaskParms parms;
    private int simField;

    public SimDebugTasklet() {
        Trace.trace(TRACE_MASKF, "<> SimDebugTasklet.constructor()");
    }

    public void logException(Throwable throwable) {
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> SimDebugTasklet.service()");
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "-> SimDebugTasklet.isInitialRequest()");
            try {
                String[] data = null;
                String sdfFile = BaseFileControl.getFilePath("iqzzsdf.h");
                String sfmFile = BaseFileControl.getFilePath("iqzzsfm.h");
                String bbsdfFile = BaseFileControl.getFilePath("iqzasdf.h");
                Trace.trace(TRACE_MASKD, "Using path " + sdfFile + "for file " + "iqzzsdf.h" + ".");
                Trace.trace(TRACE_MASKD, "Using path " + sfmFile + "for file " + "iqzzsfm.h" + ".");
                Trace.trace(TRACE_MASKD, "Using path " + bbsdfFile + "for file " + "iqzasdf.h" + ".");
                File inSdfFile = new File(sdfFile.concat("iqzzsdf.h"));
                File inSfmFile = new File(sfmFile.concat("iqzzsfm.h"));
                File inBbSdfFile = new File(bbsdfFile.concat("iqzasdf.h"));
                if (!inBbSdfFile.exists()) {
                    Trace.trace(TRACE_MASKF, "The Boe. SIM file,iqzasdf.h does not exist.");
                }
                if (inSdfFile.isFile()) {
                    Trace.trace(TRACE_MASKD, "Comdined file length = " + (inSdfFile.length() + inBbSdfFile.length() + inSfmFile.length()) + ".");
                    StringBuffer dataBuffer = new StringBuffer((int)(inSdfFile.length() + inBbSdfFile.length() + inSfmFile.length()));
                    SimDebugTasklet.processFile(inSdfFile, dataBuffer);
                    SimDebugTasklet.processFile(inSfmFile, dataBuffer);
                    if (inBbSdfFile.exists()) {
                        SimDebugTasklet.processFile(inBbSdfFile, dataBuffer);
                    }
                    StringTokenizer simFields = new StringTokenizer(new String(dataBuffer));
                    data = new String[simFields.countTokens() / 2];
                    int i = 0;
                    while (simFields.hasMoreTokens()) {
                        data[i] = simFields.nextToken().concat(" ").concat(simFields.nextToken());
                        ++i;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "IQZZSDF.H not found.");
                }
                SysInfoManagerBean bean = new SysInfoManagerBean(data);
                response.openModalChild(AUIML_FILE_NAME, PANEL_NAME, bean);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, "Exception occurred in service initial request method.");
            }
            Trace.trace(TRACE_MASKF, "<- SimDebugTasklet.isInitialRequest()");
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKD, "request.isDisposed() or isCanceled, issue response.terminate.");
            response.terminate();
        } else {
            Trace.trace(TRACE_MASKD, "request.getData(): " + request.getData("event") + ".");
            String event = (String)request.getData("event");
            SysInfoManagerBean bean = (SysInfoManagerBean)request.getData("data");
            if (event.equals("ApplyButton")) {
                try {
                    String s = bean.getSysInfoChoice();
                    int i = Integer.parseInt(s.substring(s.indexOf(" ") + 1));
                    Trace.trace(TRACE_MASKD, "SIM field index = " + i + ".");
                    SimServer.getSimServer().writeSim(i, HexString.toHexBytes(bean.getValueEdit()));
                }
                catch (IllegalArgumentException exc) {
                    Trace.trace(TRACE_MASKT, "IllegalArgumentException exception.");
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, "Exception from writeSim " + exc + ".");
                }
                response.noAction();
            } else if (event.equals("EditItem")) {
                Trace.trace(TRACE_MASKD, "bean.getSysInfoChoice() = " + bean.getSysInfoChoice() + ".");
                try {
                    String s = bean.getSysInfoChoice();
                    int i = Integer.parseInt(s.substring(s.indexOf(" ") + 1));
                    Trace.trace(TRACE_MASKD, "SIM field index = " + i + ".");
                    byte[] field = SimServer.getSimServer().readSim(i);
                    bean.setValueEdit(HexString.toHex(field));
                }
                catch (IllegalArgumentException exc) {
                    Trace.trace(TRACE_MASKT, "IllegalArgumentException exception.");
                    String[] tmpIp = new String[1];
                    BaseMessageTitle title = new BaseMessageTitle("XSIM8001");
                    MessageText[] mt = new BaseMessageText[]{new BaseMessageText("XSIM0001")};
                    Trace.trace(TRACE_MASKD, "zmt = " + mt.toString());
                    LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                    LocalizableText answer = this.showMessageBox(false, title, mt, null, null, options);
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, "Exception from readSim:");
                    Trace.trace(TRACE_MASKF, exc);
                }
                response.update(bean);
            } else if (event.equals("LoadRun")) {
                Trace.trace(TRACE_MASKD, "Read the first SIM field.");
                try {
                    byte[] field = SimServer.getSimServer().readSim(1);
                    Trace.trace(TRACE_MASKD, "SIM data returned: " + HexString.toHex(field) + ".");
                    bean.setValueEdit(HexString.toHex(field));
                    response.update(bean);
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, "2. Exception from readSim " + exc + ".");
                    response.noAction();
                }
            } else {
                Trace.trace(TRACE_MASKT, "Unknown request sent to the SimDebugTasklet.");
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- SimDebugTasklet.service()");
    }

    /*
     * WARNING - void declaration
     */
    public static void processFile(File inFile, StringBuffer buffer) {
        Trace.trace(TRACE_MASKF, "->processFile.");
        try {
            String inString;
            BufferedReader inBuf = new BufferedReader(new FileReader(inFile));
            while ((inString = inBuf.readLine()) != null) {
                void var3_4;
                if (!var3_4.startsWith("#define", 0)) continue;
                StringTokenizer st = new StringTokenizer((String)var3_4);
                st.nextToken();
                buffer.append(st.nextToken() + ' ').append(st.nextToken() + ' ');
            }
            inBuf.close();
        }
        catch (Throwable exc) {
            Trace.trace(TRACE_MASKF, "Caught exception " + exc + " processing " + inFile + ".");
        }
        Trace.trace(TRACE_MASKF, "<-processFile.");
    }
}

